package com.biz.crm.nebular.tpm.audit.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 核销申请资料表 请求vo
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmAuditFileReqVo", description = "核销申请资料表 ")
public class TpmAuditFileReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("核销申请编码")
    private String auditCode;

    @ApiModelProperty("核销申请明细编码")
    private String auditDetailCode;

    @ApiModelProperty("核销申请资料类型(1,核销资料,2,活动取证资料,3,审批资料)")
    private Integer auditFileType;

    @ApiModelProperty("活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    private String fineName;

    @ApiModelProperty("要求核销资料名称(多个名字)")
    private String auditRequireNames;

    @ApiModelProperty("描述")
    private String fileDesc;

    @ApiModelProperty("示例文件集合")
    private String exampleFiles;

    @ApiModelProperty("文件地址")
    private String addressUrl;

    @ApiModelProperty("对象名称")
    private String objectName;

}