package com.biz.crm.nebular.dms.promotion;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;


/**
 * 促销范围编辑页面VO
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "促销范围编辑页面VO")
@SaturnEntity(name = "PromotionPolicyScopeEditVo", description = "促销范围编辑页面VO")
public class PromotionPolicyScopeEditVo extends UuidVo implements Serializable {

    /**
     * 范围类型
     */
    @ApiModelProperty(value = "范围类型")
    @SaturnColumn(description = "范围类型")
    private String scopeType;


    /**
     * 范围名称
     */
    @ApiModelProperty(value = "范围名称")
    @SaturnColumn(description = "范围名称")
    private String scopeName;

    /**
     * 范围编码
     */
    @ApiModelProperty(value = "范围编码")
    @SaturnColumn(description = "范围编码")
    private String scopeCode;

    /**
     * 是否包含
     */
    @ApiModelProperty(value = "是否包含")
    @SaturnColumn(description = "是否包含")
    private String containable;

    /**
     * 政策id
     */
    @ApiModelProperty(value = "政策id")
    @SaturnColumn(description = "政策id")
    private String promotionPolicyId;

    /**
     * 政策编码
     */
    @ApiModelProperty(value = "政策编码")
    @SaturnColumn(description = "政策编码")
    private String promotionPolicyCode;

    /**
     * 政策名称
     */
    @ApiModelProperty(value = "政策名称")
    @SaturnColumn(description = "政策名称")
    private String promotionPolicyName;

}
