package com.biz.crm.nebular.mdm.constant;

public enum RegionLevelEnum {

    COUNTRY("0", "", "国家"),
    PROVINCE("1", "0", "省、自治区、直辖市"),
    CITY("2", "1", "市"),
    COUNTY("3", "2", "区、县"),
    TOWNSHIP("4", "3", "乡、镇");

    RegionLevelEnum(String code, String parentCode, String desc) {
        this.code = code;
        this.parentCode = parentCode;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getParentCode() {
        return parentCode;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 行政区域级别
     */
    private String code;
    /**
     * 上级行政区域级别
     */
    private String parentCode;
    /**
     * 描述
     */
    private String desc;

}
