package com.biz.crm.nebular.mdm.positionlevel.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 职位级别 请求vo
 *
 * @author Tao.Chen
 * @date 2020-10-22 10:56:51
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPositionLevelReqVo", description = "职位级别")
public class MdmPositionLevelReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("职位级别名称")
    private String positionLevelName;

    @ApiModelProperty("角色编码，英文逗号间隔")
    private String roleCode;

    @ApiModelProperty("角色名称，英文逗号间隔")
    private String roleName;

}