package com.biz.crm.nebular.mdm.user.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionReqVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 用户信息表请求vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserReqVo", description = "用户信息表")
public class MdmUserReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("用户账号登录信息")
    private String userName;

    @ApiModelProperty("用户编码")
    private String userCode;

    @ApiModelProperty("密码（经过加密的）")
    private String userPassword;

    @ApiModelProperty("用户类型")
    private String userType;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("电话")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    private String fullName;

    @ApiModelProperty("生效时间")
    private String endTime;

    @ApiModelProperty("失效时间")
    private String startTime;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("锁定状态")
    private String lockState;

    @ApiModelProperty("最后一次登录时间")
    private String lastLoginTime;

    @ApiModelProperty("用户头像url")
    private String userHeadUrl;

    @ApiModelProperty("职位列表")
    private List<MdmPositionReqVo> positionList;

    @ApiModelProperty("客户列表")
    private List<MdmCustomerMsgReqVo> customerList;

}