package com.biz.crm.nebular.sfa.worksign.form.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author ren.gang
 * @ClassName SfaMonthSignRespVo.java
 * @Description 月度考勤报表返回Vo
 * @createTime 2020年11月30日 13:58:00
 */
@Data
@ApiModel("月度考勤报表返回Vo")
public class SfaMonthSignRespVo {

    @ApiModelProperty("年")
    private String year;

    @ApiModelProperty("月")
    private String month;

    @ApiModelProperty("区域")
    private String parentOrgName;

    @ApiModelProperty("办事处")
    private String orgName;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员名称")
    private String realName;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("在勤")
    private Integer weekDays;

    /**
     * 累加在勤
     */
    public void addWeekDays(int num){
        weekDays = weekDays==null?0:weekDays;
        weekDays += num;
    }

    @ApiModelProperty("加班")
    private BigDecimal overtimeDays;

    /**
     * 累加加班
     */
    public void addOvertimeDays(BigDecimal num) {
        if(overtimeDays == null) {
            overtimeDays = new BigDecimal(0);
        }
        overtimeDays = overtimeDays.add(num);
    }

    @ApiModelProperty("请假")
    private BigDecimal leaveDays;

    /**
     * 累加请假
     */
    public void addLeaveDays(BigDecimal num) {
        if(leaveDays == null) {
            leaveDays = new BigDecimal(0);
        }
        leaveDays = leaveDays.add(num);
    }

    @ApiModelProperty("迟到")
    private Integer lateDays;

    /**
     * 累加迟到
     */
    public void addLateDays(int num) {
        lateDays = lateDays==null? 0: lateDays;
        lateDays += num;
    }

    @ApiModelProperty("早退")
    private Integer earlyDays;

    /**
     * 累加早退
     */
    public void addEarlyDays(int num) {
        earlyDays = earlyDays==null?0:earlyDays;
        earlyDays += num;
    }

    @ApiModelProperty("旷工")
    private BigDecimal absenteeismDays;

    /**
     * 累加旷工
     */
    public void addAbsenteeismDays(BigDecimal num) {
        if(absenteeismDays == null) {
            absenteeismDays = new BigDecimal(0);
        }
        absenteeismDays = absenteeismDays.add(num);
    }

    public static final String DAY_STATIC = "day";

    @ApiModelProperty("1号")
    private String day1;

    @ApiModelProperty("2号")
    private String day2;

    @ApiModelProperty("3号")
    private String day3;

    @ApiModelProperty("4号")
    private String day4;

    @ApiModelProperty("5号")
    private String day5;

    @ApiModelProperty("6号")
    private String day6;

    @ApiModelProperty("7号")
    private String day7;

    @ApiModelProperty("8号")
    private String day8;

    @ApiModelProperty("9号")
    private String day9;

    @ApiModelProperty("10号")
    private String day10;

    @ApiModelProperty("11号")
    private String day11;

    @ApiModelProperty("12号")
    private String day12;

    @ApiModelProperty("13号")
    private String day13;

    @ApiModelProperty("14号")
    private String day14;

    @ApiModelProperty("15号")
    private String day15;

    @ApiModelProperty("16号")
    private String day16;

    @ApiModelProperty("17号")
    private String day17;

    @ApiModelProperty("18号")
    private String day18;

    @ApiModelProperty("19号")
    private String day19;

    @ApiModelProperty("20号")
    private String day20;

    @ApiModelProperty("21号")
    private String day21;

    @ApiModelProperty("22号")
    private String day22;

    @ApiModelProperty("23号")
    private String day23;

    @ApiModelProperty("24号")
    private String day24;

    @ApiModelProperty("25号")
    private String day25;

    @ApiModelProperty("26号")
    private String day26;

    @ApiModelProperty("27号")
    private String day27;

    @ApiModelProperty("28号")
    private String day28;

    @ApiModelProperty("29号")
    private String day29;

    @ApiModelProperty("30号")
    private String day30;

    @ApiModelProperty("31号")
    private String day31;

}
