package com.biz.crm.nebular.mdm.org.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.bizunited.platform.common.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 组织终端关联返回VO
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "组织终端关联返回VO")
@CrmColumnResolve
public class MdmOrgTerminalRespVo extends UuidVo {

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("终端类型")
    private String terminalType;

    @ApiModelProperty("终端类型名称")
    @CrmDict(typeCode = "terminal_type", dictCodeField = "terminalType")
    private String terminalTypeName;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织名称")
    private String customerOrgName;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("渠道名称")
    @CrmDict(typeCode = "channel", dictCodeField = "channel")
    private String channelName;


}