package com.biz.crm.nebular.dms.repfeepool;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 货补费用池条目
 * @Author: chenrong
 * @Date: 2020/11/25 21:47
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel("货补费用池条目")
public class RepFeePoolItemDetailVo extends CrmExtVo {

  private static final long serialVersionUID = -1274235261963802038L;

  /**
   * 编码
   */
  @ApiModelProperty(value = "编码")
  private String code;

  /**
   * 支付类型
   */
  @ApiModelProperty(value = "支付类型")
  private Integer payType;

  /**
   * 产品编码
   */
  @ApiModelProperty(value = "产品编码")
  private String productCode;

  /**
   * 产品名称
   */
  @ApiModelProperty(value = "产品名称")
  private String productName;

  /**
   * 成本价格
   */
  @ApiModelProperty(value = "成本价格")
  private BigDecimal costPrice = BigDecimal.ZERO;

  /**
   * 销售价
   */
  @ApiModelProperty(value = "销售价")
  private BigDecimal salePrice = BigDecimal.ZERO;
  /**
   * 单位
   */
  @ApiModelProperty(value = "单位")
  private String unit;
  /**
   * 上账数量
   */
  @ApiModelProperty(value = "上账数量")
  private BigDecimal onAccountCount = BigDecimal.ZERO;
  /**
   * 已使用数量
   */
  @ApiModelProperty(value = "已使用数量")
  private BigDecimal usedCount = BigDecimal.ZERO;
  /**
   * 冻结数量
   */
  @ApiModelProperty(value = "冻结数量")
  private BigDecimal frozenCount = BigDecimal.ZERO;
  /**
   * 可用数量
   */
  @ApiModelProperty(value = "可用数量")
  private BigDecimal availableCount = BigDecimal.ZERO;
  /**
   * 上账金额
   */
  @ApiModelProperty(value = "上账金额")
  private BigDecimal onAccountFee = BigDecimal.ZERO;
  /**
   * 已使用金额
   */
  @ApiModelProperty(value = "已使用金额")
  private BigDecimal usedFee = BigDecimal.ZERO;
  /**
   * 冻结金额
   */
  @ApiModelProperty(value = "冻结金额")
  private BigDecimal frozenFee = BigDecimal.ZERO;
  /**
   * 可用金额
   */
  @ApiModelProperty(value = "可用金额")
  private BigDecimal availableFee = BigDecimal.ZERO;

  /**
   * 货补费用池明细编码
   */
  @ApiModelProperty(value = "货补费用池明细编码")
  private String repFeePoolItemCode;

  /**
   * 货补费用池文件列表
   */
  @ApiModelProperty(value = "货补费用池文件列表")
  private List<RepFeePoolFileVo> files;

  /**
   * 调整数量
   */
  @ApiModelProperty(value = "调整数量")
  private BigDecimal adjustCount = BigDecimal.ZERO;

  /**
   * 调整金额
   */
  @ApiModelProperty(value = "调整金额")
  private BigDecimal adjustFee = BigDecimal.ZERO;

  /**
   * 数量调整类型
   */
  @ApiModelProperty(value = "数量调整类型")
  private Integer adjustCountType;

  /**
   * 金额调整类型
   */
  @ApiModelProperty(value = "金额调整类型")
  private Integer adjustFeeType;

  /**
   * 冗余字段:冻结金额
   */
  @ApiModelProperty(value = "冻结金额")
  private BigDecimal adjustFrozenFee = BigDecimal.ZERO;

  /**
   * 冗余字段：支付类型名称
   */
  @ApiModelProperty(value = "冗余字段：支付类型名称")
  private String payTypeName;
  /**
   * 来源编码
   */
  @ApiModelProperty("来源编码")
  private String resourceCode;


}
