package com.biz.crm.nebular.mdm.org.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 组织表请求vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmOrgSelectReqVo", description = "组织下拉选择条件")
public class MdmOrgSelectReqVo {

    @ApiModelProperty("返回条数，不传返回默认条数")
    private Integer pageSize;

    @ApiModelProperty("生效状态 003停用，009启用")
    private String enableStatus;

    @ApiModelProperty("组织编码，模糊查询组织编码")
    private String orgCode;

    @ApiModelProperty("组织编码，查询这个组织的直接下级")
    private String parentCode;

    @ApiModelProperty("排除当前组织（及全部下级组织）")
    private String notUnderThisOrgCode;

    @ApiModelProperty("只查询当前组织（及全部下级组织）")
    private String underThisOrgCode;

    @ApiModelProperty("组织名称，模糊查询组织名称")
    private String orgName;

    @ApiModelProperty("模糊查询组织编码或名称")
    private String orgCodeOrName;

    @ApiModelProperty("组织类型，精确查询组织类型")
    private String orgType;

}