package com.biz.crm.nebular.mdm.position.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 职位表请求vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPositionSelectReqVo", description = "职位下拉框或列表查询")
public class MdmPositionSelectReqVo {

    @ApiModelProperty("返回条数，不传返回默认条数")
    private Integer pageSize;

    @ApiModelProperty("生效状态 003停用，009启用")
    private String enableStatus;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("关联组织编码")
    private String orgCode;

    @ApiModelProperty("上级职位编码")
    private String parentCode;

    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("是否主职位1是0否")
    private String primaryFlag;

    @ApiModelProperty("用户登录名")
    private String userName;

    @ApiModelProperty("组织名称/职位名称/用户名称")
    private String unionName;

    @ApiModelProperty("组织编码（查这个组织及全部上级组织直接关联的职位）")
    private String allAboveThisOrgCode;

    @ApiModelProperty("组织编码（查这个组织及全部下级组织的职位）")
    private String allUnderThisOrgCode;

    @ApiModelProperty("职位编码（查这个职位的全部下级职位）")
    private String allUnderThisPositionCode;

    @ApiModelProperty("职位编码（排除当前职位及下级职位）")
    private String notUnderThisPositionCode;

    @ApiModelProperty("回显编码，如果编码对应的数据满足筛选条件，则返回结果里一定包含该条数据")
    private String selectedCode;

    private String notUnderPositionRuleCode;
    private String allUnderPositionRuleCode;
    private String allUnderOrgRuleCode;
    private List<String> orgCodeList;

}