package com.biz.crm.nebular.sfa.visitdealer.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 经销商拜访明细;返回vo
 *
 * @author lf
 * @date 2020-11-17 11:22:50
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "经销商拜访明细;")
@SaturnEntity(name = "SfaVisitDealerDetailRespVo", description = "经销商拜访明细;")
public class SfaVisitDealerDetailRespVo extends CrmExtTenVo {
    @ApiModelProperty("拜访计划编码;拜访计划编码")
    @SaturnColumn(description = "拜访计划编码;拜访计划编码")
    private String visitPlanCode;

    @ApiModelProperty("拜访主键id")
    @SaturnColumn(description = "拜访主键id")
    private String visitPlanId;

    @ApiModelProperty("人员账号;人员账号")
    @SaturnColumn(description = "人员账号;人员账号")
    private String visitUserName;

    @ApiModelProperty("人员姓名;人员姓名")
    @SaturnColumn(description = "人员姓名;人员姓名")
    private String visitRealName;

    @ApiModelProperty("人员职位编码;人员职位编码")
    @SaturnColumn(description = "人员职位编码;人员职位编码")
    private String visitPosCode;

    @ApiModelProperty("人员职位名称;人员职位名称")
    @SaturnColumn(description = "人员职位名称;人员职位名称")
    private String visitPosName;

    @ApiModelProperty("人员所属组织编码;人员所属组织编码")
    @SaturnColumn(description = "人员所属组织编码;人员所属组织编码")
    private String visitOrgCode;

    @ApiModelProperty("人员所属组织名称;人员所属组织名称")
    @SaturnColumn(description = "人员所属组织名称;人员所属组织名称")
    private String visitOrgName;

    @ApiModelProperty("拜访日期;拜访日期yyyy-MM-dd")
    @SaturnColumn(description = "拜访日期;拜访日期yyyy-MM-dd")
    private String visitDate;

    @ApiModelProperty("拜访类型;拜访类型(临时拜访/计划拜访)")
    @SaturnColumn(description = "拜访类型;拜访类型(临时拜访/计划拜访)")
    private String visitType;

    @ApiModelProperty("拜访类型;拜访类型(临时拜访/计划拜访)")
    @CrmDict(typeCode = "visitType",dictCodeField = "visitType")
    private String visitTypeDesc;

    @ApiModelProperty("客户id;客户id")
    @SaturnColumn(description = "客户id;客户id")
    private String clientId;

    @ApiModelProperty("客户编码;协防客户编码")
    @SaturnColumn(description = "客户编码;协防客户编码")
    private String clientCode;

    @ApiModelProperty("客户名称;协访客户名称")
    @SaturnColumn(description = "客户名称;协访客户名称")
    private String clientName;

    @ApiModelProperty("客户类型;协访客户类型")
    @SaturnColumn(description = "客户类型;协访客户类型")
    private String clientType;

    @ApiModelProperty("客户类型;协防客户类型")
    @CrmDict(typeCode = "sfacusType",dictCodeField = "clientType")
    private String clientTypeDesc;

    @ApiModelProperty("客户电话 客户电话")
    @SaturnColumn(description = "客户电话 客户电话")
    private String clientPhone;

    @ApiModelProperty("客户头像")
    @SaturnColumn(description = "客户头像")
    private String clientPhoto;

    @ApiModelProperty("客户地址;客户地址")
    @SaturnColumn(description = "客户地址;客户地址")
    private String clientAddress;

    @ApiModelProperty("状态;拜访状态")
    @SaturnColumn(description = "状态;拜访状态")
    private String visitStatus;

    @ApiModelProperty("异常提交时间")
    @SaturnColumn(description = "异常提交时间")
    private String exceptionTime;

    @ApiModelProperty("异常描述")
    @SaturnColumn(description = "异常描述")
    private String exceptionDetail;

    @ApiModelProperty("拜访总结")
    @SaturnColumn(description = "拜访总结")
    private String visitSummary;

    @ApiModelProperty("上次拜访总结")
    @SaturnColumn(description = "上次拜访总结")
    private String lastVisitSummary;

    @ApiModelProperty("进店时间")
    @SaturnColumn(description = "进店时间")
    private String inStore;

    @ApiModelProperty("进店地址")
    @SaturnColumn(description = "进店地址")
    private String inStoreAddress;

    @ApiModelProperty("进店经度")
    @SaturnColumn(description = "进店经度")
    private BigDecimal inStoreLongitude;

    @ApiModelProperty("进店纬度")
    @SaturnColumn(description = "进店纬度")
    private BigDecimal inStoreLatitude;

    @ApiModelProperty("离店时间")
    @SaturnColumn(description = "离店时间")
    private String outStore;

    @ApiModelProperty("离店地址")
    @SaturnColumn(description = "离店地址")
    private String outStoreAddress;

    @ApiModelProperty("离店经度")
    @SaturnColumn(description = "离店经度")
    private BigDecimal outStoreLongitude;

    @ApiModelProperty("离店纬度")
    @SaturnColumn(description = "离店纬度")
    private BigDecimal outStoreLatitude;

    @ApiModelProperty("网点经度")
    private String clientLongitude;

    @ApiModelProperty("网点纬度")
    private String clientLatitude;

    @ApiModelProperty("打卡照片")
    @SaturnColumn(description = "打卡照片")
    private List<SfaVisitPictureRespVo> photoList;
}