package com.biz.crm.base.config;

import com.biz.crm.util.UserRedis;

import java.util.concurrent.ConcurrentHashMap;

/**
 * 当前用户本地变量
 */
public class ThreadLocalUtil {
    //本地用户
    protected static final ThreadLocal<UserRedis> userLocal = new ThreadLocal<>();
    //本地变量
    protected static final ThreadLocal<ConcurrentHashMap<String,Object>> threadLocalParam = new ThreadLocal<>();

    public static UserRedis getUser(){
        return userLocal.get();
    }

    public static void setUser(UserRedis user){
        userLocal.set(user);
    }
    public static void deleteUser(){
        userLocal.remove();
    }



    public static Object getObj(String key){
        ConcurrentHashMap<String,Object> map=  threadLocalParam.get();
        if (map!=null){
            return map.get(key);
        }
        return null;
    }

    public static void stObj(ConcurrentHashMap<String,Object> map){
        threadLocalParam.set(map);
    }

    public static void delObj(){
        threadLocalParam.remove();
    }

    //清除线程信息
    public static void clear(){
        ThreadLocalUtil.deleteUser();
        ThreadLocalUtil.delObj();
    }

}
