package com.biz.crm.nebular.mdm.priceconditiongroup.resp;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 条件字段分类和字段的关系表 返回vo
 *
 * @author huanglong
 * @date 2020-10-14 17:21:40
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "条件字段分类和字段的关系表 ")
@SaturnEntity(name = "MdmPriceConditionGroupRelFieldRespVo", description = "条件字段分类和字段的关系表 ")
public class MdmPriceConditionGroupRelFieldRespVo extends CrmBaseVo {
    @ApiModelProperty("条件字段分类编码")
    @SaturnColumn(description = "条件字段分类编码")
    private String conditionGroupCode;

    @ApiModelProperty("字段编码(字典)")
    @SaturnColumn(description = "字段编码(字典)")
    private String fieldCode;

    @ApiModelProperty("字段名称")
    @SaturnColumn(description = "字段名称")
    private String fieldName;

}