package com.biz.crm.nebular.mdm.product.resp;

import com.biz.crm.common.ParamCheck;
import com.biz.crm.nebular.mdm.enums.ParamCheckTypeEnum;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;
import io.swagger.annotations.ApiModelProperty;

/**
 * 商品导入vo
 * @author liaohua
 * @date 2020/9/22 2:33 下午
 */
@NebulaExcelImport(startRow = 2)
public class MdmProductImportExcelVo {
  /**
   * 商品类型
   */
  @NebulaExcelColumn(order = 0, title = "商品类型")
  @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.DICT}, msg = "商品类型不能为空", dictType = "product_type ")
  private String productType;

  /**
   * 商品编码
   */
  @NebulaExcelColumn(order = 1, title = "商品编码")
  @ParamCheck(isNotNull = true, msg = "商品编码不能为空")
  private String productCode;

  /**
   * 商品名称
   */
  @NebulaExcelColumn(order = 2, title = "商品名称")
  @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.LENGTH}, msg = "商品名称不能为空", length = 128)
  private String productName;

  /**
   * 上下架状态
   */
  @NebulaExcelColumn(order = 3, title = "上下架状态")
  @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.DICT}, msg = "上下架状态不能为空", dictType = "is_shelf")
  private String isShelf;

  /**
   * 产品层级编码
   */
  @NebulaExcelColumn(order = 4, title = "产品层级编码")
  @ParamCheck(isNotNull = true, msg = "产品层级编码不能为空")
  private String productLevelCode;

  /**
   * 规格
   */
  @NebulaExcelColumn(order = 5, title = "规格")
  @ParamCheck(isNotNull = false, checkType = {ParamCheckTypeEnum.LENGTH}, length = 128)
  private String spec;

  /**
   * 开始日期
   */
  @NebulaExcelColumn(order = 6, title = "开始日期")
  @ParamCheck(isNotNull = false)
  private String beginDate;

  /**
   * 结束日期
   */
  @NebulaExcelColumn(order = 7, title = "结束日期")
  @ParamCheck(isNotNull = false)
  private String endDate;

  /**
   * 条形码
   */
  @ApiModelProperty("条形码")
  @ParamCheck(isNotNull = false)
  private String barCode;

  public String getProductType() {
    return productType;
  }

  public void setProductType(String productType) {
    this.productType = productType;
  }

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  public String getProductName() {
    return productName;
  }

  public void setProductName(String productName) {
    this.productName = productName;
  }

  public String getIsShelf() {
    return isShelf;
  }

  public void setIsShelf(String isShelf) {
    this.isShelf = isShelf;
  }

  public String getProductLevelCode() {
    return productLevelCode;
  }

  public void setProductLevelCode(String productLevelCode) {
    this.productLevelCode = productLevelCode;
  }

  public String getSpec() {
    return spec;
  }

  public void setSpec(String spec) {
    this.spec = spec;
  }

  public String getBeginDate() {
    return beginDate;
  }

  public void setBeginDate(String beginDate) {
    this.beginDate = beginDate;
  }

  public String getEndDate() {
    return endDate;
  }

  public void setEndDate(String endDate) {
    this.endDate = endDate;
  }

  public String getBarCode() {
    return barCode;
  }

  public void setBarCode(String barCode) {
    this.barCode = barCode;
  }

  @Override
  public String toString() {
    return "MdmProductImportExcelVo{" +
        "productType='" + productType + '\'' +
        ", productCode='" + productCode + '\'' +
        ", productName='" + productName + '\'' +
        ", isShelf='" + isShelf + '\'' +
        ", productLevelCode='" + productLevelCode + '\'' +
        ", spec='" + spec + '\'' +
        ", beginDate='" + beginDate + '\'' +
        ", endDate='" + endDate + '\'' +
        ", barCode='" + barCode + '\'' +
        '}';
  }
}
