package com.biz.crm.nebular.tpm.account.resp;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 费用上账发票关联表;返回vo
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用上账发票关联表;")
@CrmColumnResolve
@SaturnEntity(name = "TpmAccountInvoiceRespVo", description = "费用上账发票关联表;")
public class TpmAccountInvoiceRespVo extends CrmExtVo {
    @ApiModelProperty("分组id(标识同一次提交的数据)")
    @SaturnColumn(description = "分组id(标识同一次提交的数据)")
    private String groupId;

    @ApiModelProperty("上账编码")
    @SaturnColumn(description = "上账编码")
    private String accountCode;

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("发票编码")
    @SaturnColumn(description = "发票编码")
    private String invoiceCode;

    @ApiModelProperty("申请科目编码")
    @SaturnColumn(description = "申请科目编码")
    private String applyBudgetSubjectsCode;

    @ApiModelProperty("申请科目名称")
    @SaturnColumn(description = "申请科目名称")
    private String applyBudgetSubjectsName;

    @ApiModelProperty("上账科目编码")
    @SaturnColumn(description = "上账科目编码")
    private String accountBudgetSubjectsCode;

    @ApiModelProperty("上账科目名称")
    @SaturnColumn(description = "上账科目名称")
    private String accountBudgetSubjectsName;

    @ApiModelProperty("税码")
    @SaturnColumn(description = "税码")
    private String taxCode;

    @ApiModelProperty("税金")
    @SaturnColumn(description = "税金")
    private String taxAmount;

    @ApiModelProperty("发票金额(不含税)")
    @SaturnColumn(description = "发票金额(不含税)")
    private BigDecimal invoiceAmount;

    @ApiModelProperty("进项税转出金额")
    @SaturnColumn(description = "进项税转出金额")
    private BigDecimal taxOutAmount;

    @ApiModelProperty("ERP成本中心(文本框输入)")
    @SaturnColumn(description = "ERP成本中心(文本框输入)")
    private String costCenter;

}