package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * 请求vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:26
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "MdmCustomerContactReqVo", description = "客户信息：联系人")
@Accessors(chain = true)
public class MdmCustomerContactReqVo extends CrmTreeVo {

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("联系人姓名")
    @NotBlank(message = "联系人姓名不能为空")
    private String contactName;

    @ApiModelProperty("联系人电话")
    private String contactPhone;

    @ApiModelProperty("主联系人,1是0否")
    private String contactMain;

}