package com.biz.crm.nebular.dms.rebatefeepool;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.CrmFileVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 折扣费用池条目调整明细VO
 * @Author: chenrong
 * @Date: 2020/11/23 16:53
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "折扣费用池条目调整明细VO")
public class RebateFeePoolDetailLogVo extends CrmExtVo {

  private static final long serialVersionUID = -4941737089772063724L;

  /**
   * 折扣费用池条目编码
   */
  @ApiModelProperty(value = "折扣费用池条目编码")
  private String rebateFeePoolDetailCode;

  /**
   * 折扣费用池条目调整明细编码
   */
  @ApiModelProperty(value = "折扣费用池条目调整明细编码")
  private String code;

  /**
   * 调整类型
   */
  @ApiModelProperty(value = "调整类型")
  private Integer adjustType;

  @ApiModelProperty(value = "调整类型名称")
  @CrmDict(typeCode="fee_adjust_type",dictCodeField="adjustType")
  private String adjustTypeName;

  /**
   * 业务来源编码
   */
  @ApiModelProperty(value = "业务来源编码")
  private String resourceCode;

  /**
   * 调整金额
   */
  @ApiModelProperty(value = "调整金额")
  private BigDecimal adjustFee = BigDecimal.ZERO;

  /**
   * 支付方式
   */
  @ApiModelProperty(value = "支付方式")
  private Integer payType;

  /**
   * 冗余字段，文件对象集合
   */
  @ApiModelProperty(value = "冗余字段，文件对象集合")
  private List<RebateFeePoolFileVo> files;

  /**
   * 折扣费用池条目
   */
  @ApiModelProperty(value = "折扣费用池条目")
  private RebateFeePoolDetailVo rebateFeePoolDetailVo;

  /**
   * 冻结金额
   */
  @ApiModelProperty(value = "冻结金额")
  private BigDecimal frozenFee = BigDecimal.ZERO;

  /**
   * 冗余字段：折扣费用池编码
   */
  @ApiModelProperty(value = "折扣费用池编码")
  private String rebateFeePoolCode;

  /**
   * 冗余字段：调整类型集合
   */
  @ApiModelProperty(value = "调整类型集合，pc端查报表传参用")
  private List<String> adjustTypes;

  /**
   * 本次上账金额
   */
  private BigDecimal onAccountFee = BigDecimal.ZERO;
  /**
   * 本次使用金额
   */
  private BigDecimal usedFee = BigDecimal.ZERO;
  /**
   * 条目当前可用余额
   */
  private BigDecimal availableFee = BigDecimal.ZERO;
}
