package com.biz.crm.nebular.job.req;

import com.biz.crm.nebular.mdm.PageVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author jerry7
 * @date 2020-12-11 15:32:21
 **/
@Data
@ApiModel(value = "XxlJobInfoReqVo", description = "任务详情查询")
public class XxlJobInfoReqVo extends PageVo {


    @ApiModelProperty("执行器ID")
    private int jobGroup;

    @ApiModelProperty("任务描述")
    private String jobDesc;

    @ApiModelProperty("添加时间")
    private Date addTime;
    @ApiModelProperty("更新时间")
    private Date updateTime;
    @ApiModelProperty("负责人")
    private String author;

    @ApiModelProperty("报警邮件")
    private String alarmEmail;

    @ApiModelProperty("调度类型")
    private String scheduleType;

    @ApiModelProperty("调度配置，值含义取决于调度类型")
    private String scheduleConf;

    @ApiModelProperty("调度过期策略")
    private String misfireStrategy;

    @ApiModelProperty("执行器路由策略")
    private String executorRouteStrategy;

    @ApiModelProperty("执行器，任务Handler名称")
    private String executorHandler;

    @ApiModelProperty("执行器，任务参数")
    private String executorParam;

    @ApiModelProperty("阻塞处理策略")
    private String executorBlockStrategy;

    @ApiModelProperty("任务执行超时时间，单位秒")
    private int executorTimeout;

    @ApiModelProperty("失败重试次数")
    private int executorFailRetryCount;

    @ApiModelProperty("GLUE类型,com.xxl.job.core.glue.GlueTypeEnum")
    private String glueType;

    @ApiModelProperty("GLUE源代码")
    private String glueSource;

    @ApiModelProperty("GLUE备注")
    private String glueRemark;

    @ApiModelProperty("GLUE更新时间")
    private Date glueUpdatetime;

    @ApiModelProperty("子任务ID，多个逗号分隔")
    private String childJobId;

    @ApiModelProperty("调度状态：0-停止，1-运行")
    private int triggerStatus;

    @ApiModelProperty("上次调度时间")
    private long triggerLastTime;

    @ApiModelProperty("下次调度时间")
    private long triggerNextTime;

    @ApiModelProperty("地址列表")
    private String addressList;
}
