package com.biz.crm.nebular.mdm.constant;

public enum UserTypeEnum {
    USER("u", "企业用户"),
    CUSTOMER("c", "客户用户"),
    ;

    UserTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private String code;
    private String desc;

    public static UserTypeEnum getEnumByCode(String code) {
        if (code != null) {
            for (UserTypeEnum item :
                    UserTypeEnum.values()) {
                if (item.getCode().equals(code)) {
                    return item;
                }
            }
        }
        return null;
    }

    public static boolean exist(String code) {
        if (code != null) {
            for (UserTypeEnum item :
                    UserTypeEnum.values()) {
                if (item.getCode().equals(code)) {
                    return true;
                }
            }
        }
        return false;
    }

    public String getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }
}
