package com.biz.crm.nebular.mdm.pricesetting.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 条件字段分类主表 请求vo
 *
 * @author huanglong
 * @date 2020-10-14 17:21:40
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPriceConditionGroupReqVo", description = "条件字段分类主表")
public class MdmPriceConditionGroupReqVo extends CrmExtTenVo {

    @ApiModelProperty("条件字段分类编码")
    private String conditionGroupCode;

    @ApiModelProperty("条件字段分类描述")
    private String conditionGroupDesc;

    @ApiModelProperty("条件编码组合key(校验编码维度不能重复用)")
    private String groupCodesKey;

    @ApiModelProperty("条件字段键值对集合(数据字典price_condition)")
    private List<MdmPriceConditionGroupRelFieldReqVo> conditionFieldList;

}