package com.biz.crm.nebular.sfa.visitdealer.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 经销商拜访月度报表;请求vo
 *
 * @author lf
 * @date 2020-11-20 11:21:59
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitDealerMonthlyReportReqVo", description = "经销商拜访月度报表;")
public class SfaVisitDealerMonthlyReportReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("人员账号;人员账号")
    private String visitUserName;

    @ApiModelProperty("人员姓名;人员姓名")
    private String visitRealName;

    @ApiModelProperty("人员职位编码;人员职位编码")
    private String visitPosCode;

    @ApiModelProperty("人员职位名称;人员职位名称")
    private String visitPosName;

    @ApiModelProperty("人员所属组织编码;人员所属组织编码")
    private String visitOrgCode;

    @ApiModelProperty("人员所属组织名称;人员所属组织名称")
    private String visitOrgName;

    @ApiModelProperty("拜访年;拜访年yyyy")
    private String visitYear;

    @ApiModelProperty("拜访月;拜访年MM")
    private String visitMonth;

    @ApiModelProperty("当月已拜访客户数量")
    private String visitAlreadyNum;

    @ApiModelProperty("销售人员客户数量")
    private String saleClientNum;

    @ApiModelProperty("当月拜访客户数量")
    private String visitClientNum;

    @ApiModelProperty("未拜访客户数量")
    private String visitNotClientNum;

    @ApiModelProperty("客户拜访率")
    private String visitClientProbability;

    @ApiModelProperty("拜访人员组织编码")
    private List<String> visitOrgCodeList;

}