package com.biz.crm.nebular.mdm.constant;

/**
 * 字典常量
 *
 * @author zxw
 */
public interface DictConstant {

    /**
     * 销售公司
     */
    String SALE_COMPANY = "sale_company";

    /**
     * 客户组织层级
     */
    String CUS_ORG_LEVEL = "cus_org_level";

    /**
     * 客户组织类型
     */
    String CUS_ORG_TYPE = "cus_org_type";

    /**
     * 用户类型：u用户，c客户用户
     */
    String USER_TYPE = "user_type";

    /**
     * 操作类型n新建职位，h已有职位
     */
    String POSITION_OPERATION = "position_operation";

    /**
     * 主职位，y是n否
     */
    String POSITION_PRIMARY = "position_primary";

    /**
     * 权限对象
     */
    String PERMISSION_OBJ = "permission_obj";

    /**
     * 权限维度
     */
    String PERMISSION_DIMENSION = "permission_dimension";

    /**
     * 数据来源
     */
    String PERMISSION_RESOURCE = "permission_resource";

    /**
     * 组织类型
     */
    String MDM_ORG_TYPE = "mdm_org_type";

    /**
     * 行政区域层级
     */
    String REGION_LEVEL = "region_level";

    /**
     * 物料基本单位
     **/
    String MATERIAL_BASE_UNIT = "material_base_unit";
    /**
     * 销售单位
     **/
    String MATERIAL_SALE_UNIT = "material_sale_unit";

    /**
     * 锁定状态
     * 003:锁定; 009:正常
     **/
    String LOCK_STATE = "lock_state";

    /**
     * 菜单模块
     */
    String FUNCTION_MODULE = "function_module";

    /**
     * 菜单类型
     */
    String FUNCTION_CONFIG = "function_config";

    /**
     * 渠道
     */
    String CHANNEL = "channel";

    /**
     * 终端类型
     */
    String TERMINAL_TYPE = "terminal_type";

    /**
     * 图标类型
     */
    String ICON_TYPE = "icon_type";
    /**
     * 按钮类型
     */
    String BUTTON_TYPE = "button_type";

    /**
     * 费用扣减、红冲排序规则
     */
    String FEE_POOL_REDUCE_RED_TRICK_RULE = "fee_reduce_redtrick_rule";

    /***
     * 货补费用池当前使用的价格类型（只能包含一条字典记录）
     */
    String REP_FEE_PRICE_TYPE_USING = "rep_fee_price_type_using";

    /**
     * 价格类型，用于或不费用上账、调整时查询价格
     */
    String PRICE_SEARCH_TYPE = "price_search_type";

    /**
     * 条件字段
     */
    String PRICE_CONDITION = "price_condition";
}
