package com.biz.crm.nebular.mdm.priceconditiontype.resp;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.priceconditiontype.req.MdmPriceConditionTypeRelGroupReqVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 条件字段类型主表 返回vo
 *
 * @author huanglong
 * @date 2020-10-20 10:57:00
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "条件字段类型主表 ")
@SaturnEntity(name = "MdmPriceConditionTypeRespVo", description = "条件字段类型主表 ")
@CrmColumnResolve
public class MdmPriceConditionTypeRespVo extends CrmBaseVo {
    @ApiModelProperty("条件字段类型编码")
    @SaturnColumn(description = "条件字段类型编码")
    private String conditionTypeCode;

    @ApiModelProperty("条件字段类型描述")
    @SaturnColumn(description = "条件字段类型描述")
    private String conditionTypeDesc;

    @ApiModelProperty("抬头/行项目)")
    @SaturnColumn(description = "抬头/行项目)")
    private String conditionTypeType;

    @ApiModelProperty("条件字段分类类型名称(head:抬头/line:行项目)")
    @SaturnColumn(description = "条件字段分类类型名称(head:抬头/line:行项目)")
    private String conditionTypeTypeName;

    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    @SaturnColumn(description = "条件类型分类关联集合")
    private List<MdmPriceConditionTypeRelGroupRespVo> conditionTypeRelGroupReqVoList;
}