package com.biz.crm.nebular.sfa.visitstep.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 拜访步骤(竞品采集);返回vo
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访步骤(竞品采集);")
@SaturnEntity(name = "SfaVisitStepColletRespVo", description = "拜访步骤(竞品采集);")
public class SfaVisitStepColletRespVo extends CrmExtVo {

    @ApiModelProperty("拜访编码")
    @SaturnColumn(description = "拜访编码")
    private String visitId;

    @ApiModelProperty("网点id")
    @SaturnColumn(description = "网点id")
    private String clientId;

    @ApiModelProperty("网点编码")
    @SaturnColumn(description = "网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    @SaturnColumn(description = "网点名称")
    private String clientName;

    @ApiModelProperty("网点类型")
    @SaturnColumn(description = "网点类型")
    private String clientType;

    @ApiModelProperty("活动名称")
    @SaturnColumn(description = "活动名称")
    private String activityName;

    @ApiModelProperty("竞品明细列表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    @SaturnColumn(description = "竞品明细列表")
    private List<SfaVisitStepColletItemRespVo> sfaVisitStepColletItemRespVos;

}