package com.biz.crm.nebular.activiti.act.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.util.Map;

/**
 * @author weston
 * @date 2020-12-08
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "StartProcessFormEngReqVo", description = "流程发起请求VO")
@AllArgsConstructor
@NoArgsConstructor
public class StartProcessFormEngReqVo {

    @ApiModelProperty(value = "用户编码", required = true)
    private String userCode;

    @ApiModelProperty(value = "岗位编码", required = true)
    private String posCode;

    @ApiModelProperty(value = "业务流程类型", required = true)
    private String costType;

    @ApiModelProperty(value = "业务来源系统", required = true)
    private String formType;

    @ApiModelProperty(value = "业务流程细类", required = true)
    private String smallType;

    @ApiModelProperty(value = "业务单号", required = true)
    private String formNo;

    @ApiModelProperty(value = "表单标题", required = true)
    private String title;

    @ApiModelProperty(value = "表单URL", required = true)
    private String formUrl;

    @ApiModelProperty(value = "表单URL", required = false)
    private String remark;

    @ApiModelProperty(value = "防重复签名验证码")
    private String signTicket;

    @ApiModelProperty(value = "业务参数(键值对,可选参数)", required = false)
    private Map<String, Object> variables;
}
