package com.biz.crm.nebular.mdm.position.req;

import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleReqVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 职位表请求vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPositionReqVo", description = "职位表")
public class MdmPositionReqVo extends CrmTreeTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("关联组织编码")
    private String orgCode;

    @ApiModelProperty("上级职位编码")
    private String parentCode;

    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("是否主职位 0否1是")
    private String primaryFlag;

    @ApiModelProperty("是否当前职位 0否1是")
    private String currentFlag;

    @ApiModelProperty("职位冗余全部关联角色编码集合，英文逗号间隔")
    private String roleCodeRedundancy;

    @ApiModelProperty("职位冗余全部关联角色名称集合，英文逗号间隔")
    private String roleNameRedundancy;

    @ApiModelProperty("操作类型 n:新建职位；h:已有职位")
    private String operationType;

    @ApiModelProperty("职位关联角色")
    private List<MdmRoleReqVo> roleList;

    @ApiModelProperty("角色编码集合，新增职位需要关联角色的时候传这个")
    private List<String> roleCodeList;

    @ApiModelProperty("流程角色编码集合，新增职位需要关联流程角色的时候传这个")
    private List<String> bpmRoleCodeList;

    @ApiModelProperty("用户id")
    private String userId;

    @ApiModelProperty("用户名")
    private String userName;
}