package com.biz.crm.nebular.mdm.product.req;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 商品下拉框请求VO
 *
 * @author crm
 * @date 2020-08-27 16:29:10
 */
@Data
@Accessors(chain = true)
@CrmColumnResolve
@EqualsAndHashCode(callSuper = false)
public class MdmProductSelectReqVo {

    @ApiModelProperty("返回数量，不传取默认数量")
    private Integer pageSize;

    @ApiModelProperty("启用状态：009启用、003停用，不传不筛选")
    private String enableStatus;

    @ApiModelProperty("商品编码：模糊查询")
    private String productCode;

    @ApiModelProperty("商品名称：模糊查询")
    private String productName;

    @ApiModelProperty("模糊查询商品编码或者商品名称")
    private String productCodeOrName;

    @ApiModelProperty("产品层级编码：精确查询")
    private String productLevelCode;

    @ApiModelProperty("商品类型(数据字典:product_type)精确查询")
    private String productType;

    @ApiModelProperty("上下架状态(数据字典:is_shelf)精确查询")
    private String isShelf;

    @ApiModelProperty("回显编码，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private List<String> selectedCodeList;
}