package com.biz.crm.nebular.mdm.material;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

@Data
@ApiModel(value = "MdmMaterialSelectReqVo", description = "物料下拉框请求VO")
@Accessors(chain = true)
public class MdmMaterialSelectReqVo {

    @ApiModelProperty("返回条数，不传返回默认条数")
    private Integer pageSize;

    @ApiModelProperty("生效状态 003停用，009启用")
    private String enableStatus;

    @ApiModelProperty("产品层级编码：精确查询")
    private String productLevelCode;

    @ApiModelProperty("物料编码：模糊查询")
    private String materialCode;

    @ApiModelProperty("物料名称：模糊查询")
    private String materialName;

    @ApiModelProperty("物料类型：精确查询")
    private String materialType;

    @ApiModelProperty("模糊查询物料编码或者名称")
    private String materialCodeOrName;

    @ApiModelProperty("回显编码，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private List<String> selectedCodeList;

}