package com.biz.crm.nebular.mdm.positionlevel.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 职位级别 请求vo
 *
 * @author Tao.Chen
 * @date 2020-10-22 10:56:51
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPositionLevelSelectReqVo", description = "职位级别下拉框请求VO")
public class MdmPositionLevelSelectReqVo {

    @ApiModelProperty("返回条数，不传返回默认条数")
    private Integer pageSize;

    @ApiModelProperty("生效状态 003停用，009启用")
    private String enableStatus;

    @ApiModelProperty("职位级别编码，模糊查询")
    private String positionLevelCode;

    @ApiModelProperty("职位级别名称，模糊查询")
    private String positionLevelName;

    @ApiModelProperty("模糊查询职位级别编码或名称")
    private String positionLevelCodeOrName;

    @ApiModelProperty("回显编码，如果编码对应的数据满足筛选条件，则返回结果里一定包含该条数据")
    private String selectedCode;

}