package com.biz.crm.nebular.sfa.visitnote.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 线路组管理 返回vo
 *
 * @author liuhongming
 * @date 2020-09-18 16:53:00
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "线路组管理 ")
@SaturnEntity(name = "SfaVisitGroupRespVo", description = "线路组管理 ")
public class SfaVisitGroupRespVo extends CrmExtVo {

    @ApiModelProperty("线路组编码 线路组编码")
    @SaturnColumn(description = "线路组编码 线路组编码")
    private String groupCode;

    @ApiModelProperty("线路组名称 线路组名称")
    @SaturnColumn(description = "线路组名称 线路组名称")
    private String groupName;

    @ApiModelProperty("人员账号 人员账号")
    @SaturnColumn(description = "人员账号 人员账号")
    private String userName;

    @ApiModelProperty("人员姓名 人员姓名")
    @SaturnColumn(description = "人员姓名 人员姓名")
    private String fullName;

    @ApiModelProperty("职位编码 职位编码")
    @SaturnColumn(description = "职位编码 职位编码")
    private String posCode;

    @ApiModelProperty("职位名称 职位名称")
    @SaturnColumn(description = "职位名称 职位名称")
    private String posName;

    @ApiModelProperty("组织编码 组织编码")
    @SaturnColumn(description = "组织编码 组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称 组织名称")
    @SaturnColumn(description = "组织名称 组织名称")
    private String orgName;

    @ApiModelProperty("线路组对应客户信息 线路组对应客户信息")
    @SaturnColumn(description = "线路组对应客户信息 线路组对应客户信息")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaVisitclientRelRespVo> sfaVisitclientRelRespVos;

    @ApiModelProperty("终端名称集合 终端名称集合")
    @SaturnColumn(description = "终端名称集合 终端名称集合")
    private String clientNames;

    @ApiModelProperty("终端数量 终端数量")
    @SaturnColumn(description = "终端数量 终端数量")
    private Integer clientRelNum;

}