package com.biz.crm.nebular.mdm.region;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "区域下拉框请求参数")
public class MdmRegionSelectReqVo {

    @ApiModelProperty("返回条数，不传返回默认条数")
    private Integer pageSize;

    @ApiModelProperty("启用状态")
    private String enableStatus;

    @ApiModelProperty("区域编码模糊查询")
    private String regionCode;

    @ApiModelProperty("区域名称模糊查询")
    private String regionName;

    @ApiModelProperty("全路径名称，模糊查询全路径中的任意一部分，不能跨“/”")
    private String unionName;

    @ApiModelProperty("上级区域编码，查询该编码的下一级区域")
    private String parentCode;

    @ApiModelProperty("查询该层级的区域")
    private String regionLevel;

    @ApiModelProperty("查询该层级的上级层级的区域（优先级大于regionLevel）")
    private String childrenLevel;

    @ApiModelProperty("区域编码或名称模糊查询")
    private String regionCodeOrName;

    @ApiModelProperty("回显编码，如果该编码对用的数据满足筛选条件，则返回数据一定包含该数据")
    private String selectedRegionCode;

    private String excludeCode;

}