package com.biz.crm.nebular.sfa.freesignconfig.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignSignReqVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 签到组 返回vo
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "签到组 ")
@SaturnEntity(name = "SfaFreesignConfigRespVo", description = "签到组 ")
public class SfaFreesignConfigRespVo extends CrmExtVo {
    @ApiModelProperty("签到组编码 签到组编码")
    @SaturnColumn(description = "签到组编码 签到组编码")
    private String freesignCode;

    @ApiModelProperty("签到组名称 签到组名称")
    @SaturnColumn(description = "签到组名称 签到组名称")
    private String freesignName;

    @ApiModelProperty("打卡类型编码 打卡类型编码")
    @SaturnColumn(description = "打卡类型编码 打卡类型编码")
    private String signTypeCode;

    @ApiModelProperty("打卡类型名称 打卡类型名称")
    @SaturnColumn(description = "打卡类型名称 打卡类型名称")
    private String signTypeName;

    @ApiModelProperty("签到组-打卡人员")
    @SaturnColumn(description = "签到组-打卡人员包含")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaFreesignPersonnelRespVo> personnelRespContainVos;
    @ApiModelProperty("签到组-打卡人员")
    @SaturnColumn(description = "签到组-打卡人员非包含")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaFreesignPersonnelRespVo> personnelRespNonInclusionVos;

    @ApiModelProperty("签到组-打卡类型")
    @SaturnColumn(description = "签到组-打卡类型")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaFreesignSignRespVo> sfaFreesignSignRespVos;



}