package com.biz.crm.nebular.dms.repfeepool;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 货补费用池条目日志VO
 * @Author: chenrong
 * @Date: 2020/11/25 21:47
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "货补费用池条目日志VO")
public class RepFeePoolItemDetailLogVo extends CrmExtVo {

    private static final long serialVersionUID = -5268334565391246884L;

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码")
    private String code;

    /**
     * 来源编码
     */
    @ApiModelProperty(value = "来源编码")
    private String resourceCode;

    /**
     * 支付类型
     */
    @ApiModelProperty(value = "支付类型")
    private Integer payType;

    /**
     * 货补费用池条目编码
     */
    @ApiModelProperty(value = "货补费用池条目编码")
    private String repFeePoolItemDetailCode;

    /**
     * 调整数量
     */
    @ApiModelProperty(value = "调整数量")
    private BigDecimal adjustCount = BigDecimal.ZERO;

    /**
     * 调整金额
     */
    @ApiModelProperty(value = "调整金额")
    private BigDecimal adjustFee = BigDecimal.ZERO;

    /**
     * 数量调整类型
     */
    @ApiModelProperty(value = "数量调整类型")
    private Integer adjustCountType;

    /**
     * 金额调整类型
     */
    @ApiModelProperty(value = "金额调整类型")
    private Integer adjustFeeType;

    /**
     * 货补费用池日志
     */
    @ApiModelProperty(value = "货补费用池日志")
    private List<RepFeePoolFileVo> files;

    /**
     * 冻结金额
     */
    @ApiModelProperty(value = "冻结金额")
    private BigDecimal frozenFee = BigDecimal.ZERO;

    /**
     * 冻结数量
     */
    @ApiModelProperty(value = "冻结数量")
    private BigDecimal frozenCount;

    /**
     * 冗余字段：货补费用池明细编码
     */
    @ApiModelProperty(value = "货补费用池明细编码")
    private String repFeePoolItemCode;

    /**
     * 本次上账金额
     */
    private BigDecimal onAccountFee = BigDecimal.ZERO;
    /**
     * 本次使用金额
     */
    private BigDecimal usedFee = BigDecimal.ZERO;
    /**
     * 条目当前可用余额
     */
    private BigDecimal availableFee = BigDecimal.ZERO;

    /**
     * 本次上账数量
     */
    private BigDecimal onAccountCount = BigDecimal.ZERO;
    /**
     * 本次使用数量
     */
    private BigDecimal usedCount = BigDecimal.ZERO;
    /**
     * 条目当前可用数量
     */
    private BigDecimal availableCount = BigDecimal.ZERO;

    @ApiModelProperty(value = "数量调整类型名称")
    @CrmDict(typeCode="fee_adjust_type",dictCodeField="adjustCountType")
    private String adjustCountTypeName;

    @ApiModelProperty(value = "金额调整类型名称")
    @CrmDict(typeCode="fee_adjust_type",dictCodeField="adjustFeeType")
    private String adjustFeeTypeName;

    /**
     * 冗余字段：销售公司编码
     */
    @ApiModelProperty(value = "冗余字段：销售公司编码")
    private String saleCompanyCode;

    /**
     * 冗余字段：销售公司名称
     */
    @ApiModelProperty(value = "冗余字段：销售公司名称")
    private String saleCompanyName;

    /**
     * 冗余字段：客户编码
     */
    @ApiModelProperty(value = "冗余字段：客户编码")
    private String cusCode;

    /**
     * 冗余字段：单价
     */
    @ApiModelProperty(value = "冗余字段：单价")
    private BigDecimal price = BigDecimal.ZERO;

    /**
     * 冗余字段：单位
     */
    @ApiModelProperty(value = "冗余字段：单位")
    private String unit;

    /**
     * 冗余字段：规格
     */
    @ApiModelProperty(value = "冗余字段：规格")
    private String spec;

    /**
     * 冗余字段：调整类型集合
     */
    @ApiModelProperty(value = "冗余字段：调整类型集合")
    private List<Integer> adjustTypes;

}
