package com.biz.crm.nebular.mdm.position.req;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 职位与客户组织关联
 *
 * @author zxw
 * @date 2020-11-03 17:31:28
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPositionCustomerOrgPageReqVo", description = "职位与客户组织关联分页")
public class MdmPositionCustomerOrgPageReqVo extends PageVo {


    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("用户帐号")
    private String userName;

    @ApiModelProperty("用户名称")
    private String fullName;

    private List<String> positionCodeList;


}