package com.biz.crm.nebular.tpm.costtypecategories.req;

import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRangeRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 活动大类 请求vo
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TmpCostTypeCategoriesReqVo", description = "活动大类 ")
public class TpmCostTypeCategoriesReqVo extends CrmTreeVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动大类编码")
    private String categoriesCode;

    @ApiModelProperty("活动大类名称")
    private String categoriesName;

    @ApiModelProperty("财务费用归类(字典)")
    private String financialFeeType;

    @ApiModelProperty("业务费用归类(字典)")
    private String businessFeeType;

    @ApiModelProperty("关联预算科目(科目编码)")
    private String budgetSubjectsCode;

    @ApiModelProperty("关联预算科目(科目名称)")
    private String budgetSubjectsName;

    @ApiModelProperty("适用活动类型(字典集合,传数组的json字符串)")
    private String activityCategoriesType;

    @ApiModelProperty("项目活动申请表单编码(配置好的表单编码)")
    private String formCode;

    @ApiModelProperty("范围信息(组织包含)")
    private List<TpmCostTypeCategoriesRangeReqVo> containOrgRangeVos;

    @ApiModelProperty("范围信息(组织非包含)")
    private List<TpmCostTypeCategoriesRangeReqVo> nonContainOrgRangeVos;

    @ApiModelProperty("范围信息(组织类型包含)")
    private List<TpmCostTypeCategoriesRangeReqVo> containOrgTypeRangeVos;

    @ApiModelProperty("范围信息(组织类型非包含)")
    private List<TpmCostTypeCategoriesRangeReqVo> nonContainOrgTypeRangeVos;

    @ApiModelProperty("关联活动细类")
    private List<TpmCostTypeCategoriesFineReqVo> fineVos;

    @ApiModelProperty("范围信息(总的数据)")
    private List<TpmCostTypeCategoriesRangeReqVo> rangeVos;


}