package com.biz.crm.nebular.upload.excel.req;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 导出文件请求vo
 *
 * @author lf
 * @date 2020-12-06 17:11:15
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ExcelExportReqVo", description = "导出文件")
public class ExcelExportReqVo extends CrmBaseVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("对象名称")
    private String objectName;

    @ApiModelProperty("文件绝对路径")
    private String filePath;

    @ApiModelProperty("文件名真实名称")
    private String fileName;

    @ApiModelProperty("用户账号")
    private String userName;

    @ApiModelProperty("真实姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("导出文件名称")
    private String excelFileName;

    @ApiModelProperty("文件编码")
    private String fileCode;

    @ApiModelProperty("文件来源")
    private String fileSource;

    @ApiModelProperty("请求文件参数")
    private String fileParam;

    @ApiModelProperty("文件状态 0-失败,1-成功,2-执行中")
    private String fileStatus;

    @ApiModelProperty("文件状态 0-失败,1-成功,2-执行中")
    @CrmDict(typeCode = "file_status",dictCodeField = "fileStatus")
    private String fileStatusDesc;

    @ApiModelProperty("文件类型(0-导入,1-导出)")
    private String fileType;

    @ApiModelProperty("开始时间")
    private String beginDate;

    @ApiModelProperty("结束时间")
    private String endDate;

}