package com.biz.crm.nebular.upload.excel.resp;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 导出文件返回vo
 *
 * @author lf
 * @date 2020-12-06 17:11:15
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "导出文件")
@SaturnEntity(name = "ExcelExportRespVo", description = "导出文件")
public class ExcelExportRespVo extends CrmBaseVo {
    @ApiModelProperty("对象名称")
    @SaturnColumn(description = "对象名称")
    private String objectName;

    @ApiModelProperty("文件绝对路径")
    @SaturnColumn(description = "文件绝对路径")
    private String filePath;

    @ApiModelProperty("文件名真实名称")
    @SaturnColumn(description = "文件名真实名称")
    private String fileName;

    @ApiModelProperty("用户账号")
    @SaturnColumn(description = "用户账号")
    private String userName;

    @ApiModelProperty("真实姓名")
    @SaturnColumn(description = "真实姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("导出文件名称")
    private String excelFileName;

    @ApiModelProperty("文件编码")
    private String fileCode;

    @ApiModelProperty("文件来源")
    private String fileSource;

    @ApiModelProperty("请求文件参数")
    private String fileParam;

    @ApiModelProperty("文件状态 0-失败,1-成功,2-执行中")
    private String fileStatus;

    @ApiModelProperty("文件状态 0-失败,1-成功,2-执行中")
    @CrmDict(typeCode = "file_status",dictCodeField = "fileStatus")
    private String fileStatusDesc;

    @ApiModelProperty("文件类型(0-导入,1-导出)")
    private String fileType;

    @ApiModelProperty("文件类型(0-导入,1-导出)")
    @CrmDict(typeCode = "file_type",dictCodeField = "fileType")
    private String fileTypeDesc;

}