package com.biz.crm.nebular.dms.repfeepool;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 货补费用池VO
 * @Author: chenrong
 * @Date: 2020/11/24 17:01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "货补费用池VO")
public class RepFeePoolVo extends CrmExtVo {

  private static final long serialVersionUID = -3922263231423313061L;

  /**
   * 货补费用池编码
   */
  @ApiModelProperty("货补费用池编码")
  private String code;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String cusCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String cusName;

  /**
   * 客户所属组织编码
   */
  @ApiModelProperty("客户所属组织编码")
  private String cusOrgCode;

  /**
   * 客户所属组织名称
   */
  @ApiModelProperty("客户所属组织名称")
  private String cusOrgName;

  /**
   * 销售公司编码
   */
  @ApiModelProperty("销售公司编码")
  private String saleCompanyCode;

  /**
   * 销售公司名称
   */
  @ApiModelProperty("销售公司名称")
  private String saleCompanyName;

  /**
   * 客户所属渠道编码
   */
  @ApiModelProperty("客户所属渠道编码")
  private String cusChannelCode;

  /**
   * 客户所属渠道名称
   */
  @ApiModelProperty("客户所属渠道名称")
  private String cusChannelName;

  /**
   * 货补费用池总额
   */
  @ApiModelProperty("货补费用池总额")
  private BigDecimal totalFee = BigDecimal.ZERO;

  /**
   * 货补费用池总数量
   */
  @ApiModelProperty("货补费用池总数量")
  private BigDecimal totalCount = BigDecimal.ZERO;

  /**
   * 货补费用池唯一约束字典编码
   */
  @ApiModelProperty("货补费用池唯一约束字典编码")
  private String uniqueDictCode;

  /**
   * 货补费用池明细列表
   */
  @ApiModelProperty("货补费用池明细列表")
  private List<RepFeePoolItemVo> repFeePoolItemVos;

  private Date createTime;

  private Date modifyTime;

  /**
   * 冗余字段：调整原因
   */
  @ApiModelProperty(value = "冗余字段：调整原因")
  private String adjustReason;
  /**
   * 上账原因
   */
  @ApiModelProperty(value = "冗余字段：上账原因")
  private String onAccountReason;
}
