package com.biz.crm.nebular.mdm.user.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.PageVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户-终端关联：分页响应
 *
 * @author zxw
 * @date 2020-10-15 10:21
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserRelationTerminalPageRespVo", description = "用户-终端关联：分页响应")
public class MdmUserRelationTerminalPageRespVo extends PageVo {

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("终端类型")
    private String terminalType;

    @ApiModelProperty("终端类型名称")
    @CrmDict(typeCode = DictConstant.TERMINAL_TYPE, dictCodeField = "terminalType")
    private String terminalTypeName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织名称")
    private String customerOrgName;

    @ApiModelProperty("终端地址")
    private String terminalAddress;

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;
}
