package com.biz.crm.nebular.sfa.visitinfo.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 拜访步骤进度 返回vo
 *
 * @Author Tao.Chen
 * @Date 2020/10/21 10:23
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访步骤进度")
@SaturnEntity(name = "SfaVisitStepProgressRespVo", description = "拜访步骤进度")
public class SfaVisitStepProgressRespVo extends CrmExtVo {

    @ApiModelProperty("进店时间")
    @SaturnColumn(description = "进店时间")
    private String inTime;

    @ApiModelProperty("进店地址")
    @SaturnColumn(description = "进店地址")
    private String inAddress;

    @ApiModelProperty("陈列执行")
    @SaturnColumn(description = "陈列执行")
    private String display;

    @ApiModelProperty("库存盘点")
    @SaturnColumn(description = "库存盘点")
    private String stock;

    @ApiModelProperty("订单采集")
    @SaturnColumn(description = "订单采集")
    private String orderCapture;

    @ApiModelProperty("活动执行")
    @SaturnColumn(description = "活动执行")
    private String activity;

    @ApiModelProperty("竞品采集")
    @SaturnColumn(description = "竞品采集")
    private String collet;

    @ApiModelProperty("拜访总结")
    @SaturnColumn(description = "拜访总结")
    private String summery;

}