package com.biz.crm.nebular.dms.rebatefeepool;

import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolFileVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 货补费用池操作记录表
 * @Author: chenrong
 * @Date: 2020/12/24 15:49
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RebateFeePoolBpmVo extends CrmExtVo {

  private static final long serialVersionUID = 1836645816551288737L;

  /**
   * 编码
   */
  private String code;
  /**
   * 调整类型
   */
  private Integer adjustType;
  /**
   * 审批状态
   */
  private Integer bpmState;
  /**
   * 客户编码
   */
  private String cusCode;
  /**
   * 客户名称
   */
  private String cusName;
  /**
   * 销售公司编码
   */
  private String saleCompanyCode;
  /**
   * 销售公司名称
   */
  private String saleCompanyName;
  /**
   * 调整金额
   */
  private BigDecimal adjustFee;
  /**
   * 审批人账号
   */
  private String bpmAccount;
  /**
   * 审批人姓名
   */
  private String bpmFullName;
  /**
   * 审批时间
   */
  private String bpmTime;
  /**
   * 录单时间
   */
  private String createTime;
  /**
   * 提交时间
   */
  private String commitTime;
  /**
   * 费用池编码
   */
  private String rebateFeePoolCode;
  /**
   * 货补费用池唯一约束字典编码
   */
  @ApiModelProperty(value = "货补费用池唯一约束字典编码")
  private String uniqueDictCode;
  /**
   * 扣减顺序字典编码
   */
  private String indexDictCode;
  /**
   * 调整原因
   */
  private String adjustReason;
  /**
   * 来源编码
   */
  private String resourceCode;
  /**
   * 文件列表
   */
  private List<RebateFeePoolFileVo>  files;
}
