package com.biz.crm.nebular.mdm.dict.req;

import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 数据字典明细表请求vo
 *
 * @author Tao.Chen
 * @date 2020-11-20 15:00:54
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmDictDataReqVo", description = "数据字典明细表")
public class MdmDictDataReqVo extends CrmTreeTenVo {

    @ApiModelProperty("字典编码")
    private String dictCode;

    @ApiModelProperty("字典名称")
    private String dictValue;

    @ApiModelProperty("字典描述")
    private String dictDesc;

    @ApiModelProperty("字典类型编码")
    private String dictTypeCode;

    @ApiModelProperty("排序")
    private String dictSort;

    @ApiModelProperty("上级id")
    private String parentId;

    @ApiModelProperty("上级编码")
    private String parentDictCode;
}