package com.biz.crm.nebular.dms.rebatefeepool;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/26 13:23
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "我的余额页面查询返回的vo")
public class SelectBanlanceRes {

    @ApiModelProperty(value = "可用现金折扣余额")
    private BigDecimal rebateBanlance;

    @ApiModelProperty(value = "可用现金折扣余额")
    private List<SelectBanlanceRebateRes> selectBanlanceRebateRes;


    @ApiModelProperty(value = "可用商品折扣余额")
    private List<SelectBanlanceRepRes> selectBanlanceRepRes;


    /**
     * 初始化一个业务上为空的对象
     * @return
     */
    public static SelectBanlanceRes instanceEmpty(){
        SelectBanlanceRes res = new SelectBanlanceRes();
        res.setRebateBanlance(BigDecimal.ZERO);
        res.setSelectBanlanceRebateRes(new ArrayList<>());
        res.setSelectBanlanceRepRes(new ArrayList<>());
        return res;
    }
}
