package com.biz.crm.nebular.dms.repfeepool;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/10/21 16:43
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "前段页面查货补上账记录返回的vo")
public class ListAccountRes extends PageVo {

    @ApiModelProperty(value = "编码")
    private String code;

    @ApiModelProperty(value = "销售公司名字")
    private String saleConpaneyName;

    @ApiModelProperty(value = "类型中文")
    private Integer type;

    @CrmDict(typeCode="notice_msg_state",dictCodeField="type")
    @ApiModelProperty(value = "类型中文")
    private String typeName;

    @ApiModelProperty(value = "订单编号")
    private String orderCode;

    @ApiModelProperty(value = "活动单号")
    private String activityCode;

    @ApiModelProperty(value = "核销单号")
    private String auditCode;

    @ApiModelProperty(value = "活动策划单号")
    private String activityPlanCode;

    @ApiModelProperty(value = "产品编码")
    private String productCode;

    @ApiModelProperty(value = "产品名称")
    private String productName;

    @ApiModelProperty(value = "单价")
    private BigDecimal price;

    @ApiModelProperty(value = "单位")
    private String unit;

    @ApiModelProperty(value = "上账数量")
    private BigDecimal accountNum;

    @ApiModelProperty(value = "上账金额")
    private BigDecimal accountAmount;

    @ApiModelProperty(value = "已使用数量")
    private BigDecimal usedNum;

    @ApiModelProperty(value = "剩余可用数量")
    private BigDecimal surplusNum;

    @ApiModelProperty(value = "日期")
    private String happenDate;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "附件地址")
    private List<String> fileUrls = new ArrayList<>();

    @ApiModelProperty(value = "创建时间（日期+时间）")
    private String createTime;

    @ApiModelProperty(value = "创建人名称")
    private String createName;
}
