package com.biz.crm.nebular.mdm.region;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 请求vo
 *
 * @author zxw
 * @date 2020-11-20 14:59:37
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmRegionReqVo", description = "")
public class MdmRegionReqVo extends CrmExtTenVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("区域编码")
    private String regionCode;

    @ApiModelProperty("区域编码集合")
    private List<String> regionCodeList;

    @ApiModelProperty("上级编码")
    private String parentCode;

    @ApiModelProperty("名称")
    private String regionName;

    @ApiModelProperty("层级 0 1 2 省市区县")
    private String regionLevel;

    @ApiModelProperty("当前区域层级，查询上级区域")
    private String currentRegionLevel;

    @ApiModelProperty("邮编")
    private String email;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("是否有子节点")
    private Boolean hasChild;

}