package com.biz.crm.nebular.mdm.productlevel.resp;

import com.biz.crm.common.ParamCheck;
import com.biz.crm.nebular.mdm.enums.ParamCheckTypeEnum;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;

import java.io.Serializable;

/**
 * @author Liao Hua
 * @date 2020/9/11 11:45 上午
 */
@NebulaExcelImport(startRow = 1)
public class MdmProductLevelImportExcelVo implements Serializable {

  /**
   * 产品层级名称
   */
  @NebulaExcelColumn(order = 0, title = "产品层级名称")
  @ParamCheck(msg = "产品层级名称不能为空", checkType = {ParamCheckTypeEnum.LENGTH}, length = 64)
  private String productLevelName;

  /**
   * 产品层级类型
   */
  @NebulaExcelColumn(order = 1, title = "产品层级类型")
  @ParamCheck(checkType = {ParamCheckTypeEnum.DICT}, dictType = "mdm_product_level_type", msg = "产品层级类型不能为空")
  private String productLevelType;

  /**
   * 上级产品层级编码
   */
  @NebulaExcelColumn(order = 2, title = "上级产品层级编码")
  @ParamCheck(isNotNull = false, msg = "上级产品层级编码")
  private String parentCode;

  /**
   * 备注
   */
  @NebulaExcelColumn(order = 3, title = "备注")
  @ParamCheck(isNotNull = false, checkType = {ParamCheckTypeEnum.LENGTH}, length = 200)
  private String remarks;

  public String getProductLevelName() {
    return productLevelName;
  }

  public void setProductLevelName(String productLevelName) {
    this.productLevelName = productLevelName;
  }

  public String getProductLevelType() {
    return productLevelType;
  }

  public void setProductLevelType(String productLevelType) {
    this.productLevelType = productLevelType;
  }

  public String getRemarks() {
    return remarks;
  }

  public void setRemarks(String remarks) {
    this.remarks = remarks;
  }

  public String getParentCode() {
    return parentCode;
  }

  public void setParentCode(String parentCode) {
    this.parentCode = parentCode;
  }

  @Override
  public String toString() {
    return "MdmProductLevelImportExcelVo{" +
        "productLevelName='" + productLevelName + '\'' +
        ", productLevelType='" + productLevelType + '\'' +
        ", parentCode='" + parentCode + '\'' +
        ", remarks='" + remarks + '\'' +
        '}';
  }
}
