package com.biz.crm.nebular.dms.repfeepool;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;


/**
 * 折扣产品信息
 *  @author: luoqi
 *  @Date: 2020-12-9 10:58
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "折扣产品信息")
public class RepFeePooItemProductInfoResVo extends CrmExtVo {

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;
  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;
  /**
   * 商品单位
   */
  @ApiModelProperty("商品单位")
  private String unit;
  /**
   * 商品单位名称
   */
  @ApiModelProperty("商品单位名称")
  private String unitName;
  /**
   * 可用数量
   */
  @ApiModelProperty("可用数量")
  private BigDecimal availableCount;
  /**
   * 可用金额
   */
  @ApiModelProperty("可用金额")
  private BigDecimal availableFee;
  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String spec;

  @ApiModelProperty("货补费用池编码")
  private String repFeePoolCode;
}
