package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.common.ParamCheck;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;

/**
 * 客户信息对接人信息导入
 * @author liaohua
 * @date 2020/10/15 4:20 下午
 */
@NebulaExcelImport(startRow = 1)
public class MdmCustomerDockingImportExcelVo {

  /**
   * 客户编码
   */
  @NebulaExcelColumn(order = 0, title = "客户编码")
  @ParamCheck(isNotNull = true, msg = "客户编码不能为空")
  private String customerCode;


  /**
   * 职位编码
   */
  @NebulaExcelColumn(order = 1, title = "职位编码")
  @ParamCheck(isNotNull = true, msg = "职位编码")
  private String positionCode;

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public String getPositionCode() {
    return positionCode;
  }

  public void setPositionCode(String positionCode) {
    this.positionCode = positionCode;
  }

  @Override
  public String toString() {
    return "MdmCustomerDockingImportExcelVo{" +
        "customerCode='" + customerCode + '\'' +
        ", positionCode='" + positionCode + '\'' +
        '}';
  }
}
