package com.biz.crm.nebular.dms.rebatefeepool;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 费用汇总返回对象
 * @Author: chenrong
 * @Date: 2020/11/30 14:24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel("费用汇总返回对象")
public class FeePoolSumReportRes {

  /**
   * 客户编码
   */
  @ApiModelProperty(value = "客户编码")
  private String cusCode;
  /**
   * 客户组织编码
   */
  @ApiModelProperty(value = "客户组织编码")
  private String cusOrgCode;
  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户名称")
  private String cusName;
  /**
   * 客户组织名称
   */
  @ApiModelProperty(value = "客户组织名称")
  private String cusOrgName;
  /**
   * 客户渠道编码
   */
  @ApiModelProperty(value = "客户渠道编码")
  private String cusChannelCode;
  /**
   * 客户渠道名称
   */
  @ApiModelProperty(value = "客户渠道名称")
  private String cusChannelName;
  /**
   * 可用费用余额
   */
  @ApiModelProperty(value = "可用费用余额")
  private BigDecimal availableBalance = BigDecimal.ZERO;
  /**
   * 上月费用余额
   */
  @ApiModelProperty(value = "上月费用余额")
  private BigDecimal lastBalance = BigDecimal.ZERO;
  /**
   * 本月上账金额
   */
  @ApiModelProperty(value = "本月上账金额")
  private BigDecimal currentOnAccountFee = BigDecimal.ZERO;
  /**
   * 本月已使用金额
   */
  @ApiModelProperty(value = "本月已使用金额")
  private BigDecimal currentUsedFee = BigDecimal.ZERO;

  /**
   * 项目
   */
  @ApiModelProperty("项目")
  private String projectName;

  /**
   * 期间
   */
  @ApiModelProperty("期间")
  private String period;

}
