package com.biz.crm.nebular.sfa.activity.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 活动产品;返回vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动产品;")
@SaturnEntity(name = "SfaActivityProductRespVo", description = "活动产品;")
public class SfaActivityProductRespVo extends CrmExtTenVo {
    @ApiModelProperty("活动执行id")
    @SaturnColumn(description = "活动执行id")
    private String activityExecutionId;

    @ApiModelProperty("产品编码")
    @SaturnColumn(description = "产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    @SaturnColumn(description = "产品名称")
    private String productName;

    @ApiModelProperty("系列名称")
    @SaturnColumn(description = "系列名称")
    private String seriesName;

    @ApiModelProperty("系列编码")
    @SaturnColumn(description = "系列编码")
    private String seriesCode;

}